/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.forge;

import com.mojang.brigadier.CommandDispatcher;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.forge.RailwaysClientImpl;
import com.railwayteam.railways.multiloader.Env;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.util.MavenVersionStringHelper;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.maven.artifact.versioning.ArtifactVersion;

@Mod(value="railways")
public class RailwaysImpl {
    static IEventBus bus;
    private static final Set<BiConsumer<CommandDispatcher<CommandSourceStack>, Boolean>> commandConsumers;

    public RailwaysImpl() {
        bus = FMLJavaModLoadingContext.get().getModEventBus();
        Railways.init();
        Env.CLIENT.runIfCurrent(() -> () -> RailwaysClientImpl.init());
    }

    public static String findVersion() {
        String versionString = "UNKNOWN";
        List infoList = ModList.get().getModFileById("railways").getMods();
        if (infoList.size() > 1) {
            Railways.LOGGER.error("Multiple mods for MOD_ID: railways");
        }
        for (IModInfo info : infoList) {
            if (!info.getModId().equals("railways")) continue;
            versionString = MavenVersionStringHelper.artifactVersionToString((ArtifactVersion)info.getVersion());
            break;
        }
        return versionString;
    }

    public static void finalizeRegistrate() {
        Railways.registrate().registerEventListeners(bus);
    }

    public static void registerCommands(BiConsumer<CommandDispatcher<CommandSourceStack>, Boolean> consumer) {
        commandConsumers.add(consumer);
    }

    @SubscribeEvent
    public static void onCommandRegistration(RegisterCommandsEvent event) {
        Commands.CommandSelection selection = event.getEnvironment();
        boolean dedicated = selection == Commands.CommandSelection.ALL || selection == Commands.CommandSelection.DEDICATED;
        commandConsumers.forEach(consumer -> consumer.accept(event.getDispatcher(), dedicated));
    }

    public static void registerConfig(ModConfig.Type type, ForgeConfigSpec spec) {
        ModLoadingContext.get().registerConfig(type, (IConfigSpec)spec);
    }

    static {
        commandConsumers = new HashSet<BiConsumer<CommandDispatcher<CommandSourceStack>, Boolean>>();
    }
}

